/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.mixin;

import immersive_aircraft.entity.AircraftEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class})
public abstract class PlayerEntityMixin
extends Entity {
    public PlayerEntityMixin(EntityType<?> type, Level world) {
        super(type, world);
    }

    @Inject(method={"wantsToStopRiding"}, at={@At(value="HEAD")}, cancellable=true)
    void shouldDismountInjection(CallbackInfoReturnable<Boolean> cir) {
        if (this.m_20201_() instanceof AircraftEntity) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"updatePlayerPose()V"}, at={@At(value="TAIL")})
    void updatePostInjection(CallbackInfo ci) {
        if (this.m_20201_() instanceof AircraftEntity) {
            this.m_20124_(Pose.STANDING);
        }
    }

    @Inject(method={"isScoping()Z"}, at={@At(value="HEAD")}, cancellable=true)
    void isScopingInjection(CallbackInfoReturnable<Boolean> cir) {
        AircraftEntity aircraft;
        Entity entity = this.m_20201_();
        if (entity instanceof AircraftEntity && (aircraft = (AircraftEntity)entity).isScoping()) {
            cir.setReturnValue((Object)true);
        }
    }
}

